; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.

command.buffer.time = 1


;----------------------------------------------------------------------


;-| AI |-------------------------------------------------------------
[Command]
name = "CPU1"
command = U,U,U,U,F,F,F,F
time = 1

[Command]
name = "CPU2"
command = U,D,DB,U,F,F,F,F,D
time = 1

[Command]
name = "CPU3"
command = U,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU4"
command = U,D,F,U,F,F,F,F,U,D,B
time = 1

[Command]
name = "CPU5"
command = U,B,F,U,F,F,F,F,U,D,B
time = 1

[Command]
name = "CPU6"
command = U,B,F,U,F,F,F,F,U,D,F,B
time = 1

[Command]
name = "CPU7"
command = U,B,F,U,F,F,F,F,U,D,F,B,D
time = 1

[Command]
name = "CPU8"
command = U,B,F,U,F,F,F,F,U,D,F,B,D,F
time = 1

[Command]
name = "CPU9"
command = U,B,F,U,F,F,F,F,U,D,F,B,D,F,B
time = 1


[Command]
name = "CPU10"
command = U,B,F,U,F,F,F,F,U,D,F,B,D,F,B,F
time = 1

[Command]
name = "CPU11"
command = U,B,F,U,F,F,F,F,U,D,F,B,D,F,B,F,D
time = 1

[Command]
name = "CPU12"
command = U,B,F,U,F,F,F,F,U,D,F,B,D,F,B,F,B
time = 1

[Command]
name = "CPU13"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F,DB
time = 1

[Command]
name = "CPU14"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU15"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU16"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1

[Command]
name = "CPU17"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a
time = 1

[Command]
name = "CPU18"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a,x
time = 1

[Command]
name = "CPU19"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a,b
time = 1

[Command]
name = "CPU20"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a
time = 1

[Command]
name = "CPU21"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a,a
time = 1

[Command]
name = "CPU2"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,a,y
time = 1




;------------------------------------------------------------------------


[command]
name = "leiken1"
command = D,B,y
time = 20

[command]
name = "leiken2"
command = D,B,x
time = 20

[command]
name = "leiken3"
command = D,F,x
time = 15

[command]
name = "leiken4"
command = D,B,x
time = 20

[command]
name = "leiken5"
command = D,DF,F,y
time = 30

[command]
name = "leiken6"
command = D,B, a;~30$B, $F, y
time = 20

[command]
name = "leiken10"
command = D,B, b;~30$B, $F, y
time = 20

[Command]
name = "leiken7"
command = D,B,y
time = 15

[Command]
name = "leiken8"
Command = D,D, a
time = 25

[Command]
name = "leiken9"
Command = D,D, b
time = 25


[Command]
name = "SocoChao"
command = y+b
time = 25

[Command]
name = "esquiva"
command = x+a
time = 25

[Command]
name = "Empurra"
command = y+b
time = 20

;[Command]
;name = "devolta"
;command = c
;time=15

[Command]
name = "charge"
command = /y

[Command]
name = "charge 1"
command = /b


[Command]
name = "Superpulo"
command = ~D, U
time = 15

[Command]
name = "Superpulo"
command = ~D, UF
time = 25

[Command]
name = "Superpulo"
command = ~D, UB
time = 25

[Command]
name = "hold_s"
command = /z
time = 1

;-----------------------------especial----------------------------
[command]
name = "yukina"
command = D,B,D,B, x
time = 30


[command]
name = "especial2"
command = D,F,D,F,y
time = 30

[command]
name = "espadaDime"
command = D,F,D,F,x
time = 25

[Command]
name = "KuwadaraYusuke"
command = D,F,DF,F, y+b
time = 34

[Command]
name = "KuwadaraYusuke1"
command = D,B,DB,B, y+b
time = 34




;[Command]
;name = "D_DF_F_D_DF_F_x+a"
;command = c
;time = 20


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdx"
command = /x
time = 1

[Command]
name = "holda"
command = /a
time = 1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================

;===========================================================================
;---------------------------------------------------------------------------

;=========================================================================

[state -1]
type = changestate
triggerall = random < 100
triggerall = var(59) = 1
triggerall = stateno != 40
triggerall = statetype != a
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numhelper >= 1)
trigger1 = ctrl = 1
trigger2 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger2 = ctrl = 1
value = 40

[state -1]
type = varset
trigger1 = var(59) = 1
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger1 = ctrl = 1
v = 3
value = 1

[State -1, Inteligencia]
type = VarSet
trigger1  = command = "CPU1"
trigger2  = command = "CPU2"
trigger3  = command = "CPU3"
trigger4  = command = "CPU4"
trigger5  = command = "CPU5"
trigger6  = command = "CPU6"
trigger7  = command = "CPU7"
trigger8  = command = "CPU8"
trigger9  = command = "CPU9"
trigger10  = command = "CPU10"
trigger11  = command = "CPU11"
trigger12  = command = "CPU12"
trigger13  = command = "CPU13"
trigger14  = command = "CPU14"
trigger15  = command = "CPU15"
trigger16  = command = "CPU16"
trigger17  = command = "CPU17"
trigger18  = command = "CPU18"
trigger19  = command = "CPU19"
trigger20  = command = "CPU20"
trigger21  = command = "CPU21"
v = 59
value = 1

[state -1]
type = changestate
value = 0
triggerall = var(59) = 1
triggerall = roundstate = 3
trigger1 = statetype != a
trigger1 = ctrl


;ground combo 0--------------------------------------------------
[state -1,1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]


[state -1]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 200
trigger1 = movecontact

[state -1]
type = changestate
value = 202
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201
trigger1 = movecontact
;trigger1 = random < 10

[state -1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201
trigger1 = movecontact
;trigger1 = random < 50

[state -1]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210
trigger1 = movecontact
;trigger1 = random < 50

[state -1]
type = changestate
value = 212
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact
;trigger1 = random < 50

;ground combo 1--------------------------------------------------
[state -1,1]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]


[state -1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact

[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact
;trigger1 = random < 50

[state -1]
type = changestate
value = 231
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact
;trigger1 = random < 50


[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 231
trigger1 = movecontact
;trigger1 = random < 50

[state -1]
type = changestate
value = 241
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 240
trigger1 = movecontact
;trigger1 = random < 50

;ground combo 2--------------------------------------------------
[state -1,1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,35]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,35]


[state -1]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210
trigger1 = movecontact

[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact


[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact


[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact
;trigger1 = random < 100

[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact
;trigger1 = random < 100


[state -1]
type = changestate
value = 60
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 410
trigger1 = (Movehit)
trigger1 = movecontact
;trigger1 = random < 100

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 35
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
trigger1 = stateno = 600
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
trigger1 = stateno = 600
trigger1 = movecontact
trigger1 = p2bodydist x < 35
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
trigger1 = stateno = 630
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 610
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
trigger1 = stateno = 640
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = time >10
trigger1 = stateno = 640 ||  stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


;ground combo 3--------------------------------------------------
[state -1,1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,25]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,25]



[state -1]
type = changestate
value = 241
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 240
trigger1 = movecontact


[state -1]
type = changestate
value = 241
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 240
trigger1 = movecontact

[state -1]
type = changestate
value = 3000
triggerall = statetype != a
triggerall = power >= 1500
triggerall = time >18
triggerall = var(59) = 1 && roundstate =2
trigger1 = (Movehit)
trigger1 = stateno = 241 || stateno = 410 ||  stateno = 703  || stateno = 705 ||  stateno = 720  || stateno = 1501
trigger1 = movecontact


[state -1]
type = changestate
value = 3000
triggerall = statetype != a
triggerall = power >= 1500
triggerall = time >18
triggerall = var(59) = 1 && roundstate =2
trigger1 = (Movehit)
trigger1 = stateno = 241 || stateno = 410 ||  stateno = 703  || stateno = 705 ||  stateno = 720  || stateno = 1501
;trigger1 = movecontact


[state -1]
type = changestate
value = 711
triggerall = statetype != a
triggerall = power >= 2000
triggerall = time >18
triggerall = var(59) = 1 && roundstate =2
trigger1 = (Movehit)
trigger1 = stateno = 241 ||  stateno = 703  || stateno = 705 ||  stateno = 720  || stateno = 1501
trigger1 = movecontact


[state -1]
type = changestate
value = 711
triggerall = statetype != a
triggerall = power >= 2000
triggerall = time >18
triggerall = var(59) = 1 && roundstate =2
trigger1 = (Movehit)
trigger1 = stateno = 241 || stateno = 703  || stateno = 705 ||  stateno = 720  || stateno = 1501
;trigger1 = movecontact



;ground combo 4--------------------------------------------------
[state -1,1]
type = changestate
value = 700
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 150
trigger1 = p2bodydist x = [0,50]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,50]


[state -1]
type = changestate
value = 730
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 700
trigger1 = movecontact
trigger1 = random < 10


[state -1]
type = changestate
value = 720
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 730
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1501
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno = 720
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1501
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno = 730
trigger1 = movecontact
trigger1 = random < 10


;ground combo 5--------------------------------------------------
[state -1,1]
type = changestate
value = 701
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 150
trigger1 = p2bodydist x = [0,35]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,35]


[state -1]
type = changestate
value = 720
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 701
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 730
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 701
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1501
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno = 701
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1501
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >20
;trigger1 = (Movehit)
trigger1 = stateno = 700 ||  stateno = 701  || stateno = 720 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >25
;trigger1 = (Movehit)
trigger1 = stateno = 1501 ;||  stateno = 701  || stateno = 720 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >25
trigger1 = (Movehit)
trigger1 = stateno = 1501 ;||  stateno = 720;  || stateno = 720 
trigger1 = movecontact
trigger1 = random < 10


[state -1]
type = changestate
value = 703
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time > 20
;trigger1 = (Movehit)
trigger1 = stateno = 1501 ||  stateno = 720 ; || stateno = 720 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 702
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno = 1501 ||  stateno = 720  || stateno = 720 
trigger1 = movecontact
trigger1 = random < 10


[state -1]
type = changestate
value = 706
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 212  ||  stateno = 241  
trigger1 = movecontact
trigger1 = random < 10


[state -1]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = time >15
trigger1 = (Movehit)
trigger1 = stateno = 706 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = time >15
trigger1 = (Movehit)
trigger1 = stateno = 706 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 702
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >15
trigger1 = (Movehit)
trigger1 = stateno = 706 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1500
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >15
trigger1 = (Movehit)
trigger1 = stateno = 706 
trigger1 = movecontact
trigger1 = random < 10


;----------------------------GOLPES AI --------------------------------
[state -1,1]
type = changestate
value = 703
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 150
trigger1 = p2bodydist x = [0,90]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,120]


[state -1,1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 150
trigger1 = p2bodydist x = [0,110]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,160]


[state -1,1]
type = changestate
value = 706
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 250
trigger1 = p2bodydist x = [0,50]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,85]


[state -1,1]
type = changestate
value = 713
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 250
trigger1 = p2bodydist x = [0,60]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,93]


[state -1,1]
type = changestate
value = 731
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 300
trigger1 = p2bodydist x = [0,63]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,103]


[state -1,1]
type = changestate
value = 731
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 300
trigger1 = p2bodydist x = [0,98]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,148]

[state -1,1]
type = changestate
value = 710
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 150
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,40]


;-------------Especiais AI----------------------------------------

[state -1,1]
type = changestate
value = 708
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 1000
trigger1 = p2bodydist x = [0,33]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,43]


[state -1,1]
type = changestate
value = 711
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 2000
trigger1 = p2bodydist x = [0,115]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,145]


[state -1,1]
type = changestate
value = 2106
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 2500
trigger1 = p2bodydist x = [0,100]
trigger1 = random < 10
trigger2 = stateno = 20
trigger2 = p2bodydist x = [0,160]


[state -1,1]
type = changestate
value = 3100
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
triggerall = power >= 2500
trigger1 = p2bodydist x = [0,90]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,110]

[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != A
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [150,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 160


[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != A
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [151,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 161

[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != S
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [152,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 162


;--------------------------Especial-----------------------------


[State -1]
type = ChangeState
value = 2106
triggerall = !Var(59)
triggerall = command = "KuwadaraYusuke1"
triggerall = numproj = 0
triggerall = statetype != A
triggerall = power >= 2500
trigger1 = ctrl = 1
trigger2 = stateno = [250,280]
trigger2 = (MoveContact && time <= 10) || time = [5,20]
trigger3 = stateno = [400,430]
trigger3 = MoveContact
trigger4 = stateno = 240 || stateno = 321 || stateno = 420 || stateno = 430
trigger4 = time = [7,14]
trigger4 = MoveContact
trigger5 = stateno = 220 
trigger5 = (MoveContact) || time = [5,11]
trigger6 = stateno = 1000 || stateno = 1001 || stateno = 1002 || stateno = 1203



[State -1, ]
type = ChangeState
value = 3100
triggerall = command = "KuwadaraYusuke"
trigger1 = statetype = S
triggerall = power >= 2500
trigger1 = ctrl

[State -1]
type = ChangeState
value = 3000
;triggerall = var(59) != 1
;triggerall = RoundState = 2
triggerall = Life <= (LifeMax/4) || Life > (LifeMax/4) && power >= 1500
triggerall = command = "espadaDime"
triggerall = command != "holdy"
triggerall = statetype != A
trigger1 = ctrl || (stateno = 40 && time = 3 || stateno = 100 && time >= 2) || (stateno = 101 && time >= 1)
trigger2 = ((stateno = 6505 || stateno = 6515) && time >= 12) || (stateno = 6530 && movehit)
trigger3 = stateno = 200 && var(58) = [1,2]
trigger3 = movecontact && AnimElemTime(13) < 0
trigger4 = stateno = 210
trigger4 = movecontact && AnimElemTime(15) < 0
trigger5 = stateno = 220
trigger5 = movecontact && AnimElemTime(11) < 0
trigger6 = stateno = 230
trigger6 = movecontact && AnimElemTime(34) < 0
trigger7 = stateno = 250
trigger7 = movecontact && AnimElemTime(23) < 0
trigger8 = stateno = 260 && var(58) = 0
trigger8 = movecontact && AnimElemTime(30) < 0
trigger9 = stateno = 300 && var(58) = [1,2]
trigger9 = movecontact && AnimElemTime(9) < 0
trigger10 = stateno = 310
trigger10 = movecontact && AnimElemTime(33) < 0
trigger11 = stateno = 320 && var(58) = [1,2]
trigger11 = movecontact && AnimElemTime(14) < 0
trigger12 = stateno = 330
trigger12 = movecontact && AnimElemTime(16) < 0
trigger13 = stateno = 500
trigger13 = movecontact && AnimElemTime(21) < 0
trigger14 = stateno = 3400 && movecontact





;-----------------------Golpes--------------------------------------------


[State -1, ]
type = ChangeState
value = 711
trigger1 = command = "especial2"
triggerall = power >= 1500
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 708
trigger1 = command = "yukina"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl

;------------------------------------------------------------------

[State -1, ]
type = ChangeState
value = 700
trigger1 = command = "leiken1"
triggerall = power >= 150
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 701
trigger1 = command = "leiken2"
triggerall = power >= 150
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 703
trigger1 = command = "leiken3"
triggerall = power >= 150
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 702
trigger1 = command = "leiken4"
triggerall = power >= 150
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 705
triggerall = command = "leiken5"
trigger1 = statetype = S
triggerall = power >= 250
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 706
trigger1 = command = "leiken6"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 710
trigger1 = command = "esquiva"
triggerall = power >= 150
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 731
triggerall = command = "leiken8"
trigger1 = statetype = S
triggerall = power >= 300
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 1501
triggerall = command = "leiken9"
trigger1 = statetype = S
triggerall = power >= 250
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 713
trigger1 = command = "leiken10"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, "leiken7"]
type = ChangeState
value = 1500
triggerall = command = "leiken7"
triggerall = power >= 250
TriggerAll = var(30) != 1
trigger1 = statetype != S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact
trigger3 = stateno = 210
trigger3 = movecontact
trigger4 = stateno = 230
trigger4 = movecontact
trigger5 = stateno = 240
trigger5 = movecontact
trigger6 = stateno = 400
trigger6 = movecontact
trigger7 = stateno = 410
trigger7 = movecontact
trigger8 = stateno = 430
trigger8 = movecontact
trigger9 = stateno = 440
trigger9 = movecontact
trigger10 = stateno = 220
trigger10 = movecontact
trigger11 = stateno = 250
trigger11 = movecontact
trigger12 = StateNo = 40
trigger13 = StateNo = 11
trigger14 = StateNo = 12

;----------------------------------------------------------------------------
; Carregar Energia 01
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command="hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)

[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl


[State -1, correndo frente ar]
type = ChangeState
value = 102
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, correndo traz ar]
type = ChangeState
value = 115
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl


[State -1:Super pulo]
type = ChangeState
value = 60
triggerall = !var(59)&&command = "Superpulo"
trigger1 = (statetype = S) && (ctrl)


[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl


[State -1, Guard Push stand]
type = ChangeState
value = 160
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = S
trigger1 = stateno = [150,153]

[State -1, Guard Push crouch]
type = ChangeState
value = 161
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = C
trigger1 = stateno = [150,153]

[State -1, Guard Push aerial]
type = ChangeState
value = 162
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = A
trigger1 = stateno = [154,155]


;---------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
;triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 6

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S


;---------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

[State -1]
type = ChangeState
value = 211
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 241
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9


[State -1]
type = ChangeState
value = 232
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 241
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 240
triggerall = movecontact = 1
trigger1 = statetype = S




[State -1]
type = ChangeState
value = 200
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)


[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 7
trigger3 = stateno = 1350 ;Air blocking

[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 7
trigger3 = stateno = 1350 ;Air blocking


[State -1]
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 600
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking


[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking


[State -1]
type = ChangeState
value = 610
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A









